## DeepSeek 开源项目

## 官方开源

| 项目名称          | 项目链接                                         | 简介                                                         |
| ----------------- | ------------------------------------------------ | ------------------------------------------------------------ |
| DeepSeek-R1       | https://github.com/deepseek-ai/DeepSeek-R1       | DeepSeek的旗舰语言模型，提供高质量的响应，支持多种自然语言处理任务。 |
| DeepSeek-V3       | https://github.com/deepseek-ai/DeepSeek-V3       | DeepSeek的第三个版本，采用创新的混合专家架构（MoE），支持多模态搜索。 |
| DeepSeek-V2       | https://github.com/deepseek-ai/DeepSeek-V2       | 一款强大、经济高效的专家混合语言模型                         |
| DeepSeek-Coder-V2 | https://github.com/deepseek-ai/DeepSeek-Coder-V2 | 采用混合专家（Mixture-of-Experts，MoE）架构，突破闭源模型在代码智能中的壁垒 |
| DeepSeek-Coder    | https://github.com/deepseek-ai/DeepSeek-Coder    | 用于辅助代码编写的AI工具，支持多种编程语言。                 |
| DeepSeek-LLM      | https://github.com/deepseek-ai/DeepSeek-LLM      | 提供准确可靠答案的综合语言模型。                             |
| Janus             | https://github.com/deepseek-ai/Janus             | 统一的多模态理解与生成模型                                   |
| DreamCraft3D      | https://github.com/deepseek-ai/DreamCraft3D      | 基于引导扩散先验的分层3D生成模型的官方实现                   |
| DeepSeek-Math     | https://github.com/deepseek-ai/DeepSeek-Math     | 通过增强模型的数学理解和推理能力，突破了传统语言模型在数学领域的限制，能够处理更复杂的数学推理任务，如符号计算、定理证明等 |
| DeepSeek-MoE      | https://github.com/deepseek-ai/DeepSeek-MoE      | 创新的混合专家架构模型，支持高效推理。                       |
| DeepSeek-VL2      | https://github.com/deepseek-ai/DeepSeek-VL2      | 用于先进多模态理解的专家混合视觉-语言模型                    |
| DeepSeek-VL       | https://github.com/deepseek-ai/DeepSeek-VL       | 通过深度学习技术增强视觉和语言的融合，解决复杂的视觉-语言任务 |



## 其他有关 DeepSeek 开源项目

| 项目名称                 | 项目链接                                                    | 简介                                               |
| ------------------------ | ----------------------------------------------------------- | -------------------------------------------------- |
| DeepSeek-API-Integration | https://github.com/deepseek-ai/awesome-deepseek-integration | 整理了DeepSeek API的集成应用，支持多种平台和语言。 |
| GPT4Free                 | https://github.com/xtekky/gpt4free                          | 提供免费访问DeepSeek V3 & R1等模型的接口。         |
| CherryStudio             | https://github.com/CherryHQ/cherry-studio                   | 支持包括DeepSeek-R1在内的多款LLM的桌面客户端。     |
| TinyZero                 | https://github.com/Jiayi-Pan/TinyZero                       | 伯克利团队复现DeepSeek R1-Zero的项目。             |
| simpleRL-reason          | https://github.com/hkust-nlp/simpleRL-reason                | 港科大团队复现DeepSeek R1-Zero和R1的项目。         |
| DeepSeek-Free            | https://github.com/deepseek-free/deepseek-free              | 提供DeepSeek部署教程和免费API接口。                |
| Unlock-DeepSeek          | https://github.com/datawhalechina/unlock-deepseek           | 面向AI研究爱好者的DeepSeek系列工作解读和复现。     |